<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OfferClaim extends Model
{
    protected $table = 'offer_claims';
    
    protected $fillable = [
        'user_id',
        'offer_id',
        'invites_completed',
        'bonus_claimed',
        'claimed_at'
    ];

    protected $casts = [
        'bonus_claimed' => 'decimal:8',
        'claimed_at' => 'datetime'
    ];

    // Relationship with user
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relationship with offer
    public function offer()
    {
        return $this->belongsTo(TimeLimitedOffer::class, 'offer_id');
    }
}
