@extends('admin.layouts.app')
@section('panel')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th scope="col">@lang('User')</th>
                                <th scope="col">@lang('Offer')</th>
                                <th scope="col">@lang('Invites Completed')</th>
                                <th scope="col">@lang('Bonus Claimed')</th>
                                <th scope="col">@lang('Claimed At')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($claims as $claim)
                            <tr>
                                <td>
                                    <span class="fw-bold">{{ $claim->user->fullname }}</span>
                                    <br>
                                    <span class="small">
                                        <a href="{{ route('admin.users.detail', $claim->user_id) }}"><span>@</span>{{ $claim->user->username }}</a>
                                    </span>
                                </td>
                                <td>{{ __($offer->title) }}</td>
                                <td>{{ $claim->invites_completed }}</td>
                                <td class="fw-bold">{{ showAmount($claim->bonus_claimed) }} {{ $general->cur_text }}</td>
                                <td>{{ showDateTime($claim->claimed_at) }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage ?? 'No claims found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if($claims->hasPages())
            <div class="card-footer">
                {{ paginateLinks($claims) }}
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('breadcrumb-plugins')
<a href="{{ route('admin.time.offers.index') }}" class="btn btn-outline--primary btn-sm"><i class="las la-undo"></i> @lang('Back') </a>
@endpush
