@extends('admin.layouts.app')
@section('panel')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form role="form" method="POST" action="{{ route('admin.time.offers.store') }}">
                    @csrf
                    <div class="row">
                        <div class="form-group col-md-12">
                            <label>@lang('Title')</label>
                            <input type="text" name="title" class="form-control" value="{{ old('title') }}" placeholder="@lang('Offer Title')" required>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label>@lang('Bonus Amount')</label>
                            <div class="input-group">
                                <input type="number" step="any" name="bonus_amount" class="form-control" value="{{ old('bonus_amount') }}" placeholder="@lang('0.00')" required>
                                <div class="input-group-text">{{ $general->cur_text }}</div>
                            </div>
                        </div>

                        <div class="form-group col-md-6">
                            <label>@lang('Required Invites')</label>
                            <div class="input-group">
                                <input type="number" name="required_invites" class="form-control" value="{{ old('required_invites') }}" placeholder="@lang('Number of paid invites needed')" required min="1">
                                <div class="input-group-text">@lang('Invites')</div>
                            </div>
                        </div>

                        <div class="form-group col-md-6">
                            <label>@lang('Start Time')</label>
                            <input type="text" name="start_time" class="form-control datepicker-here" data-timepicker="true" data-language="en" autocomplete="off" value="{{ old('start_time') }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>@lang('End Time')</label>
                            <input type="text" name="end_time" class="form-control datepicker-here" data-timepicker="true" data-language="en" autocomplete="off" value="{{ old('end_time') }}" required>
                        </div>

                        <div class="form-group col-md-12">
                            <label>@lang('Status')</label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-on="@lang('Active')" data-off="@lang('Inactive')" name="status" value="1" checked>
                        </div>
                    </div>

                    <div class="form-group col-md-12 mt-3">
                        <button type="submit" class="btn btn--primary h-45 w-100">@lang('Create Offer')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('breadcrumb-plugins')
<a href="{{ route('admin.time.offers.index') }}" class="btn btn-outline--primary btn-sm"><i class="las la-undo"></i> @lang('Back') </a>
@endpush

@push('script-lib')
  <script src="{{ asset('assets/admin/js/vendor/datepicker.min.js') }}"></script>
  <script src="{{ asset('assets/admin/js/vendor/datepicker.en.js') }}"></script>
@endpush

@push('script')
  <script>
    (function($){
        "use strict";
        $('.datepicker-here').datepicker({
            timepicker: true,
            language: 'en',
            dateFormat: 'mm/dd/yyyy',
            timeFormat: 'hh:ii aa'
        });
    })(jQuery)
  </script>
@endpush
