@extends('admin.layouts.app')
@section('panel')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form role="form" method="POST" action="{{ route('admin.time.offers.update', $offer->id) }}">
                    @csrf
                    <div class="row">
                        <div class="col-md-12 mb-4">
                            @if($offer->status)
                                <div class="alert alert-success" role="alert">
                                    <h4 class="alert-heading text-success"><i class="las la-check-circle"></i> @lang('Offer is CURRENTLY LIVE')</h4>
                                    <p class="mb-0">@lang('Users can see this offer on their dashboard.')</p>
                                </div>
                            @else
                                <div class="alert alert-danger" role="alert">
                                    <h4 class="alert-heading text-danger"><i class="las la-ban"></i> @lang('Offer is DISABLED')</h4>
                                    <p class="mb-0">@lang('This offer is hidden from users.')</p>
                                </div>
                            @endif
                        </div>

                        <div class="form-group col-md-12">
                            <label>@lang('Title')</label>
                            <input type="text" name="title" class="form-control" value="{{ old('title', $offer->title) }}" placeholder="@lang('Offer Title')" required>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label>@lang('Bonus Amount')</label>
                            <div class="input-group">
                                <input type="number" step="any" name="bonus_amount" class="form-control" value="{{ old('bonus_amount', $offer->bonus_amount + 0) }}" placeholder="@lang('0.00')" required>
                                <div class="input-group-text">{{ $general->cur_text }}</div>
                            </div>
                        </div>

                        <div class="form-group col-md-6">
                            <label>@lang('Required Invites')</label>
                            <div class="input-group">
                                <input type="number" name="required_invites" class="form-control" value="{{ old('required_invites', $offer->required_invites) }}" placeholder="@lang('Number of paid invites needed')" required min="1">
                                <div class="input-group-text">@lang('Invites')</div>
                            </div>
                        </div>

                        <div class="form-group col-md-6">
                            <label>@lang('Start Time')</label>
                            <input type="text" name="start_time" class="form-control datepicker-here" data-timepicker="true" data-language="en" autocomplete="off" value="{{ old('start_time', $offer->start_time->format('m/d/Y H:i')) }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>@lang('End Time')</label>
                            <input type="text" name="end_time" class="form-control datepicker-here" data-timepicker="true" data-language="en" autocomplete="off" value="{{ old('end_time', $offer->end_time->format('m/d/Y H:i')) }}" required>
                        </div>

                        <div class="form-group col-md-12">
                            <label>@lang('Status')</label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-on="@lang('Active')" data-off="@lang('Inactive')" name="status" value="1" @if($offer->status) checked @endif>
                        </div>
                    </div>

                    <div class="form-group col-md-12 mt-3">
                        <button type="submit" class="btn btn--primary h-45 w-100">@lang('Update Offer')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('breadcrumb-plugins')
    <a href="{{ route('admin.time.offers.index') }}" class="btn btn-outline--primary btn-sm"><i class="las la-undo"></i> @lang('Back') </a>
    <a href="{{ route('admin.time.offers.claims', $offer->id) }}" class="btn btn-outline--info btn-sm"><i class="las la-list"></i> @lang('View Claims')</a>
@endpush

@push('script-lib')
  <script src="{{ asset('assets/admin/js/vendor/datepicker.min.js') }}"></script>
  <script src="{{ asset('assets/admin/js/vendor/datepicker.en.js') }}"></script>
@endpush

@push('script')
  <script>
    (function($){
        "use strict";
        $('.datepicker-here').datepicker({
            timepicker: true,
            language: 'en',
            dateFormat: 'mm/dd/yyyy',
            timeFormat: 'hh:ii aa'
        });
    })(jQuery)
  </script>
@endpush
