@extends('admin.layouts.app')
@section('panel')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th scope="col">@lang('Title')</th>
                                <th scope="col">@lang('Bonus')</th>
                                <th scope="col">@lang('Invites Required')</th>
                                <th scope="col">@lang('Start Time')</th>
                                <th scope="col">@lang('End Time')</th>
                                <th scope="col">@lang('Status')</th>
                                <th scope="col">@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($offers as $offer)
                            <tr>
                                <td>{{ __($offer->title) }}</td>
                                <td class="fw-bold">{{ showAmount($offer->bonus_amount) }} {{ $general->cur_text }}</td>
                                <td>{{ $offer->required_invites }}</td>
                                <td>{{ showDateTime($offer->start_time) }}</td>
                                <td>{{ showDateTime($offer->end_time) }}</td>
                                <td>
                                    @if($offer->isActive())
                                        <span class="badge badge--success">@lang('Active')</span>
                                    @elseif($offer->status && $offer->end_time < now())
                                        <span class="badge badge--danger">@lang('Expired')</span>
                                    @elseif($offer->status && $offer->start_time > now())
                                        <span class="badge badge--info">@lang('Upcoming')</span>
                                    @else
                                        <span class="badge badge--warning">@lang('Disabled')</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.time.offers.claims', $offer->id) }}" class="btn btn-sm btn-outline--info">
                                        <i class="la la-list"></i> @lang('Claims')
                                    </a>
                                    <a href="{{ route('admin.time.offers.edit', $offer->id) }}" class="btn btn-sm btn-outline--primary">
                                        <i class="la la-pen"></i> @lang('Edit')
                                    </a>
                                    <button class="btn btn-sm btn-outline--{{ $offer->status ? 'danger' : 'success' }} confirmationBtn"
                                        data-question="@lang('Are you sure to') {{ $offer->status ? 'disable' : 'enable' }} @lang('this offer?')"
                                        data-action="{{ route('admin.time.offers.status', $offer->id) }}">
                                        <i class="la la-{{ $offer->status ? 'eye-slash' : 'eye' }}"></i> {{ $offer->status ? __('Disable') : __('Enable') }}
                                    </button>
                                    <button class="btn btn-sm btn-outline--danger confirmationBtn"
                                        data-question="@lang('Are you sure to delete this offer?')"
                                        data-action="{{ route('admin.time.offers.delete', $offer->id) }}">
                                        <i class="la la-trash"></i> @lang('Delete')
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage ?? 'No offers found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if($offers->hasPages())
            <div class="card-footer">
                {{ paginateLinks($offers) }}
            </div>
            @endif
        </div>
    </div>
</div>

<div id="confirmationModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Confirmation')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <p class="question"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('No')</button>
                    <button type="submit" class="btn btn--primary">@lang('Yes')</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('breadcrumb-plugins')
    <a href="{{ route('admin.time.offers.create') }}" class="btn btn-outline--primary btn-sm"><i class="las la-plus"></i> @lang('Create Offer')</a>
@endpush

@push('script')
<script>
    (function ($) {
        "use strict";
        $('.confirmationBtn').on('click', function () {
            var modal = $('#confirmationModal');
            modal.find('.question').text($(this).data('question'));
            modal.find('form').attr('action', $(this).data('action'));
            modal.modal('show');
        });
    })(jQuery);
</script>
@endpush
