@foreach($formData as $data)
 <div>
                  <label for="recipient-name" class="text-xl font-medium">Enter{{ __($data->name) }}:</label>
        @if($data->type == 'text')

                  <input type="text" class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" placeholder="{{ __($data->name) }} Title" name="{{ $data->label }}" required>
              
        @elseif($data->type == 'textarea')
            <textarea
                class="form-control form--control"
                name="{{ $data->label }}"
                @if($data->is_required == 'required') required @endif
            >{{ old($data->label) }}</textarea>
        @elseif($data->type == 'select')
<select  class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" name="{{ $data->label }}">
    @foreach ($data->options as $item)
        <option value="{{ $item }}" {{ $item == old($data->label) ? 'selected' : '' }}>
            {{ __($item) }}
        </option>
    @endforeach
</select>

        @elseif($data->type == 'checkbox')
            @foreach($data->options as $option)
                <div class="form-check">
                    <input
                        class="form-check-input"
                        name="{{ $data->label }}[]"
                        type="checkbox"
                        value="{{ $option }}"
                        id="{{ $data->label }}_{{ titleToKey($option) }}"
                    >
                    <label class="form-check-label" for="{{ $data->label }}_{{ titleToKey($option) }}">{{ $option }}</label>
                </div>
            @endforeach
        @elseif($data->type == 'radio')
            @foreach($data->options as $option)
                <div class="form-check">
                    <input
                    class="form-check-input"
                    name="{{ $data->label }}"
                    type="radio"
                    value="{{ $option }}"
                    id="{{ $data->label }}_{{ titleToKey($option) }}"
                    @checked($option == old($data->label))
                    >
                    <label class="form-check-label" for="{{ $data->label }}_{{ titleToKey($option) }}">{{ $option }}</label>
                </div>
            @endforeach
        @elseif($data->type == 'file')
                  <input type="file" class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" placeholder="{{ __($data->name) }} Title" name="{{ $data->label }}" required>

        @endif
    </div>
@endforeach
