<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
@if (session()->has('notify'))
    @foreach (session('notify') as $msg)
        <script>
            "use strict";
            swal({
                title: "{{ __($msg[1]) }}",
                icon: "{{ $msg[0] }}",
                button: "OK",
            });
        </script>
    @endforeach
@endif
 
@if (isset($errors) && $errors->any())
    @php
        $collection = collect($errors->all());
        $errors = $collection->unique();
    @endphp

    <script>
        "use strict";
        @foreach ($errors as $error)
            swal({
                title: '{{ __($error) }}',
                icon: "error",
                button: "OK",
            });
        @endforeach
    </script>
@endif

<script>
    "use strict";

    function notify(status, message) {
        if (typeof message == 'string') {
            swal({
                title: message,
                icon: status,
                button: "OK",
            });
        } else {
            $.each(message, function(i, val) {
                swal({
                    title: val,
                    icon: status,
                    button: "OK",
                });
            });
        }
    }
</script>
