@extends($activeTemplate.'layouts.frontend')
@section('content')
@php
    $content = getContent('register.content',true);
    $policyPages = getContent('policy_pages.element', false, null, true);
@endphp
<body class="bg-green-600">
  <main>
    <div class="w-full flex flex-col items-center justify-start pt-10 gap-4 px-4 pb-10">
      <span>
      <img src="{{ getImage(getFilePath('logoIcon') .'/logo.png') }}">
      </span>
          					<form action="{{ route('user.register') }}"  class="bg-white p-12 rounded-lg w-full max-w-md flex flex-col gap-3" method="post">
                        @csrf
        <h2 class="text-3xl font-bold text-center">Sign Up</h2>
        <label class="text-xl font-medium" for="name">Name</label>
        <input class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="text" name="username" id="username" />
        <label class="text-xl font-medium" for="email">Email</label>
        <input class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="email" name="email" id="email" />
        <label class="text-xl font-medium" for="phone">Phone</label>
        <input class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="mobile" name="mobile"  id="mobile"  />
        <label class="text-xl font-medium" for="account">Select Account</label>
        <select name="account" class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required id="">
          <!-- <option value="jazzcash">JazzCash</option> -->
                                          @foreach($withdrawMethod as $data)
                                    <option value="{{ $data->id }}" data-resource="{{$data}}">  {{__($data->name)}}</option>
                                @endforeach
                                    </select>
        <label class="text-xl font-medium" for="phone">Contry</label>
        <input class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="text" value="Pakistan"  name="city" id="phone" />
        <label class="text-xl font-medium" for="password">Password</label>
        <input class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="password" name="password" id="password" />
        <label class="text-xl font-medium" for="confirm_password">Confirm Password</label>
        <input class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" type="password" name="password_confirmation" id="password_confirmation" />
                           						@if (session()->get('reference') != null)

               <label style="Color:red">Referral Name</label>

        <input class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" type="name"  value="{{ session()->get('reference') }}" />
            @endif
                <button type="submit" class="focus:outline-none text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:ring-green-300 font-medium rounded-lg text-lg w-full py-2">SignUp</button>
        <p class="text-lg text-center font-medium">Already Have An Account? <a href="login" class="text-green-600">Login</a></p>
      </form>
    </div>
  </main>
@endsection

@if($general->secure_password)
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif

@push('script')
    <script>
        "use strict";
        (function($) {
            @if ($mobileCode)
                $(`option[data-code={{ $mobileCode }}]`).attr('selected', '');
            @endif

            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));

            $('.checkUser').on('focusout', function(e) {
                var url = '{{ route('user.checkUser') }}';
                var value = $(this).val();
                var token = '{{ csrf_token() }}';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
