@extends($activeTemplate.'layouts.master')
@section('content')
<div class="show-filter mb-3 text-end">
    <button type="button" class="btn btn--base showFilterBtn btn-sm"><i class="las la-filter"></i> @lang('Filter')</button>
</div>
<div class="card responsive-filter-card mb-4">
    <div class="card-body">
        <form action="">
            <div class="d-flex flex-wrap gap-4">
                <div class="flex-grow-1">
                    <label class="form-label">@lang('TRX/Username')</label>
                    <input type="text" name="search" value="{{ request()->search }}" class="form-control form--control">
                </div>
                <div class="flex-grow-1">
                    <label class="form-label">@lang('Remark')</label>
                    <div class="form--select">
                        <select class="form-select" name="remark">
                            <option value="">@lang('Any')</option>
                            <option value="deposit_commission">@lang('Deposit Commission')</option>
                            <option value="plan_subscribe_commission">@lang('Plan Subscribe Commission')</option>
                            <option value="ptc_view_commission">@lang('Advertisement View Commission')</option>
                        </select>
                    </div>
                </div>
                <div class="flex-grow-1">
                    <label class="form-label">@lang('Levels')</label>
                    <div class="form--select">
                        <select class="form-select" name="level">
                            <option value="">@lang('Any')</option>
                            @for($i = 1; $i <= $levels; $i++)
                                <option value="{{ $i }}">{{__(ordinal($i))}} @lang('Level')</option>
                            @endfor
                        </select>
                    </div>
                </div>
                <div class="flex-grow-1 align-self-end">
                    <button class="btn btn--base btn--lg w-100"><i class="las la-filter"></i> @lang('Filter')</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="custom--table-container table-responsive--md">
    <table class="table custom--table">
        <thead>
        <tr>
            <th>@lang('Transaction')</th>
            <th>@lang('Commission From')</th>
            <th>@lang('Commission Level')</th>
            <th>@lang('Commission Type')</th>
            <th>@lang('Amount')</th>
        </tr>
        </thead>
        <tbody>
            @forelse($commissions as $log)
            <tr>
                <td>{{ $log->trx }}</td>
                <td>{{ __($log->userFrom->username) }}</td>
                <td>{{ ordinal($log->level) }}</td>
                <td>
                    @if($log->type == 'deposit_commission')
                        <span class="badge badge--success">@lang('Deposit')</span>
                    @elseif($log->type == 'plan_subscribe_commission')
                        <span class="badge badge--dark">@lang('Plan Subscribe')</span>
                    @else
                        <span class="badge badge--primary">@lang('Ads View')</span>
                    @endif
                </td>
                <td>{{ showAmount($log->amount) }} {{ __($general->cur_text) }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

<div class="d-flex justify-content-end mt-4">
    {{paginateLinks($commissions)}}
</div>

@endsection


@push('script')
<script>
    (function($){
    "use strict"
        $('[name=remark]').val('{{ request()->remark }}');
        $('[name=level]').val('{{ request()->level }}');
    })(jQuery);
</script>
@endpush
