    @auth
        @if(auth()->user()->p_status != 1)
            @php
                header("Location: " . route('user.deposit.index'));
                exit();
            @endphp
        @endif
    @endauth
    @extends($activeTemplate.'layouts.master')
@section('content')
<body class="bg-green-600">

    <div class="flex items-center justify-center flex-col w-full max-w-lg mx-auto px-4 py-10 gap-4">
        <div class="row justify-content-center">
            <div class="flex items-center justify-center">
                <a href="{{ route('user.home') }}">
                    <img src="{{ getImage(getFilePath('logoIcon') .'/logo.png') }}">
                </a>
            </div>
        </div>

        <div class="w-full">
            <form action="register" method="post" class="bg-white p-12 rounded-lg w-full flex flex-col gap-2">
                <h2 class="text-3xl font-bold text-center">Profile</h2>
                <label class="text-xl font-medium" for="name">Name</label>
                <input disabled class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="text" name="name" value="{{$user->username}}" id="name" />
                <label class="text-xl font-medium" for="email">Email</label>
                <input disabled class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="email" name="email" value="{{$user->email}}" id="email" />
                <label class="text-xl font-medium" for="phone">Phone</label>
                <input disabled class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="number" name="phone" required id="phone" value="{{$user->mobile}}" />
                <label class="text-xl font-medium" for="phone">City</label>
                <input disabled class="border border-2 w-full rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 p-2 text-lg" required type="text" name="city" value="{{@$user->address->city}}" id="phone" />
            </form>
        </div>

    </div>
    <!--/row-->
@endsection