    @auth
        @if(auth()->user()->p_status != 1)
            @php
                header("Location: " . route('user.deposit.index'));
                exit();
            @endphp
        @endif
    @endauth
    @extends($activeTemplate.'layouts.master')
@section('content')
<body class="bg-green-600">
    <section class="flex flex-col items-center justify-center gap-3 px-3 py-10">
        <div class="flex items-center justify-center">
                   <a href="{{ route('user.home') }}">
                <img src="{{ getImage(getFilePath('logoIcon') .'/logo.png') }}">
            </a>
        </div>
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-8">
                <div class="login-wrap p-4 p-md-5">
                    <div class="row">
                        @forelse($ads as $ad)
                            @if($ad->schedule)
                                @php
                                    $currentTime = now()->format('H:i');
                                    $validSchedule = collect($ad->schedule)
                                        ->where('day', strtolower(now()->format('l')))
                                        ->where('start', '<', $currentTime)
                                        ->where('end', '>', $currentTime)
                                        ->first();
                                @endphp
                                @if(!$validSchedule)
                                    @continue
                                @endif
                            @endif
                            <div class="bg-white p-2 rounded-md mb-3">
                                <div id='vidWrapper' class="mb-2 rounded-md">
                                    <video src="{{ $ad->ads_body }}" controls class="w-full max-w-sm rounded-md"></video>
                                </div>
<button class="focus:outline-none text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:ring-green-300 font-medium rounded-lg text-lg w-full py-2"
    onclick="window.location.href = '{{ route('user.ptc.confirm', encrypt($ad->id.'|'.auth()->user()->id)) }}'">
    Collect Reward
</button>
                            </div>
                        @empty
                            <p>No ads available.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
