    @auth
        @if(auth()->user()->p_status != 1)
            @php
                header("Location: " . route('user.deposit.index'));
                exit();
            @endphp
        @endif
    @endauth
    @extends($activeTemplate.'layouts.master')
@section('content')
<body class="bg-green-600">
  <section class="flex flex-col items-center justify-center gap-3 px-3 py-10  max-w-md mx-auto">
    <div class="flex items-center justify-center">
            <a href="{{ route('user.home') }}">
                <img src="{{ getImage(getFilePath('logoIcon') .'/logo.png') }}">
      </a>
    </div>
    <div class="w-full w-max-lg mx-auto bg-white rounded-lg flex flex-col items-center justify-start pt-6 gap-4 px-4 pb-10">
      <div class="flex flex-col items-center justify-between gap-3">
        <h2 class="text-2xl font-bold text-center">Level:{{ $user->level }} </h2>
<h2 class="text-2xl font-medium text-center">Member: {{ App\Models\User::where('ref_by', auth()->user()->id)->count() }}</h2>
      <a href="{{ route('home') }}?reference={{ $user->username }}">
<div>
    <a id="copyLinkBtn">
        <button class="focus:outline-none text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:ring-green-300 px-2 font-medium rounded-lg text-lg w-full py-2">
            Copy Referral Link
        </button>
    </a>

</div>

<script>
    document.getElementById('copyLinkBtn').addEventListener('click', function() {
        var link = "{{ route('home') }}?reference={{ $user->username }}";
        var dummyInput = document.createElement('input');
        document.body.appendChild(dummyInput);
        dummyInput.value = link;
        dummyInput.select();
        document.execCommand('copy');
        document.body.removeChild(dummyInput);

        alert('Link copied to clipboard: ' + link);
    });
</script>

<a href="{{ route('user.reward.clam') }}">
<button onClick="collectbonus()" class="focus:outline-none text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:ring-green-300 px-2 font-medium rounded-lg text-lg w-full py-2">
 Collect Bonus
</button> </a>       </div>

<div class="w-full">
    <table class="w-full text-lg">
        <thead>
            <tr class="border-2 border-green-600 text-center">
                <th class="border-2 border-green-600 text-center">Name</th>
                <th class="border-2 border-green-600 text-center">Status</th>
                <th class="border-2 border-green-600 text-center">Joined At</th>
            </tr>
        </thead>
        <tbody>
@forelse($refUsers as $log)
    <tr class="border-2 border-green-600 text-center">
        <td class="border-2 border-green-600 text-center">{{ $log->username }}</td>
        <td class="border-2 border-green-600 text-center">
            @if($log->plan_id > 0)
                Paid
            @else
                Unpaid
            @endif
        </td>
        <td class="border-2 border-green-600 text-center">{{ $log->created_at }}</td>
    </tr>
@empty
    <tr>
        <td colspan="4" class="text-center">No users found</td>
    </tr>
@endforelse

        </tbody>
    </table>
</div>

<div class="d-flex justify-content-end mt-4">
    {{paginateLinks($refUsers)}}
</div>

@endsection
@push('style')
<style type="text/css">
    .copytextDiv{
        border:1px solid #00000021;
        cursor: pointer;
    }
    #referralURL{
        border-right: 1px solid #00000021;
    }
    .bg-success-custom{
        background-color: #28a7456e!important;
    }
    .brd-success-custom{
        border: 1px dashed #28a745;
    }
</style>
@endpush
@push('script')
<script type="text/javascript">
    (function ($) {
        "use strict";
        $('#copyBoard').click(function(){
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            iziToast.success({message: "Copied: " + copyText.value, position: "topRight"});
        });
    })(jQuery);
</script>
@endpush
