    @auth
        @if(auth()->user()->p_status != 1)
            @php
                header("Location: " . route('user.deposit.index'));
                exit();
            @endphp
        @endif
    @endauth
    @extends($activeTemplate.'layouts.master')
@section('content')
<body class="bg-green-600">
  <section class="flex flex-col items-center justify-center gap-3 px-3 py-10 max-w-md mx-auto">
    <div class="flex items-center justify-center">
             <a href="{{ route('user.home') }}">
                <img src="{{ getImage(getFilePath('logoIcon') .'/logo.png') }}">
            </a>
    </div>
    <div class="w-full w-max-lg mx-auto bg-white rounded-lg flex flex-col items-center justify-start pt-10 gap-4 px-4 pb-10">
      <div class="flex flex-col items-center justify-center gap-3">
        <h1 class="text-6xl font-bold text-center">Rs: {{ showamount($user->balance) }}</h1>
        <button type="button" class="focus:outline-none text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:ring-green-300 font-medium rounded-lg text-lg w-full py-2" data-modal-target="authentication-modal" data-modal-toggle="authentication-modal">Withdraw</button>
      </div>
<table class="w-full">
    <h2 class="text-2xl font-bold text-center">Withdraw History</h2>
    <thead>
        <tr class="border-2 border-green-600 text-center">
            <th class="border-2 border-green-600 text-center">Amount</th>
            <th class="border-2 border-green-600 text-center">Status</th>
            <th class="border-2 border-green-600 text-center">Created At</th>
        </tr>
    </thead>
<tbody>
    @forelse($withdraws as $withdraw)
        <tr class="border-2 border-green-600 text-center">
            <td class="border-2 border-green-600 text-center">{{ showAmount($withdraw->amount) }} {{ $general->cur_sym }}</td>
            <td class="border-2 border-green-600 text-center">
                @php echo $withdraw->statusBadge @endphp
            </td>
            <td class="border-2 border-green-600 text-center">{{ showDateTime($withdraw->created_at) }} <br>  {{ diffForHumans($withdraw->created_at) }}</td>
        </tr>
    @empty
        <tr>
            <td colspan="3" class="text-center">No withdrawal history found</td>
        </tr>
    @endforelse
</tbody>

</table>

    </div>
<div id="authentication-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full h-full p-4 overflow-x-hidden overflow-y-auto bg-gray-900 bg-opacity-50">
   <div class="flex items-center justify-center h-full">
      <div class="bg-white rounded-lg shadow-md w-full md:max-w-md">
         <button type="button" class="absolute top-3 right-2.5 text-gray-600 hover:text-gray-900 rounded-lg p-2" data-modal-hide="authentication-modal">
            <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
               <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
            </svg>
            <span class="sr-only">Close modal</span>
         </button>
         <div class="p-6 md:p-8">
            <div class="flex items-center justify-center">
               <a href="{{ route('user.home') }}" enctype="multipart/form-data">
                  <img src="{{ getImage(getFilePath('logoIcon') .'/logo.png') }}" alt="Logo">
               </a>
            </div>
            <h3 class="text-2xl font-semibold text-center mb-4">Withdraw</h3>
                <form class="space-y-4" action="{{route('user.withdraw.money')}}" method="post">
    @csrf
               <x-viser-form identifier="id" identifierValue="{{ $method->form_id }}" />
               <label for="recipient-name" class="block text-lg font-medium">Enter Amount:</label>
               <input type="text" class="w-full p-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-green-600 focus:border-0 text-lg" placeholder="Enter Amount"  name="amount" required>
               <button type="submit" class="bg-green-600 hover:bg-green-700 focus:bg-green-700 focus:ring-2 focus:ring-green-300 text-white font-medium rounded-lg w-full py-2">Submit</button>
            </form>
         </div>
      </div>
   </div>
</div>     </section>
@endsection


