
<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form role="form" method="POST" action="<?php echo e(route('admin.time.offers.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="form-group col-md-12">
                            <label><?php echo app('translator')->get('Title'); ?></label>
                            <input type="text" name="title" class="form-control" value="<?php echo e(old('title')); ?>" placeholder="<?php echo app('translator')->get('Offer Title'); ?>" required>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label><?php echo app('translator')->get('Bonus Amount'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" name="bonus_amount" class="form-control" value="<?php echo e(old('bonus_amount')); ?>" placeholder="<?php echo app('translator')->get('0.00'); ?>" required>
                                <div class="input-group-text"><?php echo e($general->cur_text); ?></div>
                            </div>
                        </div>

                        <div class="form-group col-md-6">
                            <label><?php echo app('translator')->get('Required Invites'); ?></label>
                            <div class="input-group">
                                <input type="number" name="required_invites" class="form-control" value="<?php echo e(old('required_invites')); ?>" placeholder="<?php echo app('translator')->get('Number of paid invites needed'); ?>" required min="1">
                                <div class="input-group-text"><?php echo app('translator')->get('Invites'); ?></div>
                            </div>
                        </div>

                        <div class="form-group col-md-6">
                            <label><?php echo app('translator')->get('Start Time'); ?></label>
                            <input type="text" name="start_time" class="form-control datepicker-here" data-timepicker="true" data-language="en" autocomplete="off" value="<?php echo e(old('start_time')); ?>" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label><?php echo app('translator')->get('End Time'); ?></label>
                            <input type="text" name="end_time" class="form-control datepicker-here" data-timepicker="true" data-language="en" autocomplete="off" value="<?php echo e(old('end_time')); ?>" required>
                        </div>

                        <div class="form-group col-md-12">
                            <label><?php echo app('translator')->get('Status'); ?></label>
                            <input type="checkbox" data-width="100%" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('Active'); ?>" data-off="<?php echo app('translator')->get('Inactive'); ?>" name="status" value="1" checked>
                        </div>
                    </div>

                    <div class="form-group col-md-12 mt-3">
                        <button type="submit" class="btn btn--primary h-45 w-100"><?php echo app('translator')->get('Create Offer'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.time.offers.index')); ?>" class="btn btn-outline--primary btn-sm"><i class="las la-undo"></i> <?php echo app('translator')->get('Back'); ?> </a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
  <script src="<?php echo e(asset('assets/admin/js/vendor/datepicker.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/admin/js/vendor/datepicker.en.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
  <script>
    (function($){
        "use strict";
        $('.datepicker-here').datepicker({
            timepicker: true,
            language: 'en',
            dateFormat: 'mm/dd/yyyy',
            timeFormat: 'hh:ii aa'
        });
    })(jQuery)
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/atearnpr/demo1.atearnprofit.pro/core/resources/views/admin/time_offers/create.blade.php ENDPATH**/ ?>