<?php $__env->startSection('panel'); ?>
<div class="row">
  <div class="col-md-12">
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive--sm">
                <table class="table table--light style--two">
                    <thead>
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('Title'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Posted By'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Type'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Duration'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Maximum View'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Viewed'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Remain'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ptc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e(strLimit($ptc->title,20)); ?></td>
                                <td>
                                    <?php if($ptc->user): ?>
                                        <span class="fw-bold"><?php echo e($ptc->user->fullname); ?></span>
                                        <br>
                                        <span class="small">
                                            <a href="<?php echo e(route('admin.users.detail',$ptc->user_id)); ?>"><span>@</span><?php echo e($ptc->user->username); ?></a>
                                        </span>
                                    <?php else: ?>
                                        <span class="fw-bold"><?php echo app('translator')->get('Admin'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo $ptc->typeBadge ?>
                                </td>
                                <td><?php echo e($ptc->duration); ?> <?php echo app('translator')->get('Sec'); ?></td>
                                <td><?php echo e($ptc->max_show); ?></td>
                                <td><?php echo e($ptc->showed); ?></td>
                                <td><?php echo e($ptc->remain); ?></td>

                                <td class="fw-bold"><?php echo e(showAmount($ptc->amount)); ?> <?php echo e($general->cur_text); ?></td>

                                <td>
                                    <?php echo $ptc->statusBadge ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.ptc.engagement', $ptc->id)); ?>" class="btn btn-sm btn-outline--info">
                                        <i class="la la-eye"></i><?php echo app('translator')->get('Engagement'); ?>
                                    </a>
                                    <a class="btn btn-outline--primary btn-sm ms-1" href="<?php echo e(route('admin.ptc.edit',$ptc->id)); ?>"><i class="la la-pen"></i> <?php echo app('translator')->get('Edit'); ?></a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($ads->hasPages()): ?>
        <div class="card-footer">
            <?php echo e(paginateLinks($ads)); ?>

        </div>
        <?php endif; ?>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(route('admin.ptc.create')); ?>" class="btn btn-outline--primary btn-sm"><i class="las la-plus"></i> <?php echo app('translator')->get('Add New'); ?></a>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ptctheme/d1.superearning.online/core/resources/views/admin/ptc/index.blade.php ENDPATH**/ ?>