<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Time Offers</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>

/* ================= GLOBAL ================= */
body{
    margin:0;
    background:#1db954;
    font-family:Arial, Helvetica, sans-serif;
}

.container{
    max-width:1100px;
    margin:auto;
    padding:15px;
}

.row{
    display:flex;
    flex-wrap:wrap;
    justify-content:center;
}

.col{
    width:100%;
    max-width:360px;
    padding:10px;
}

/* ================= CARD ================= */
.offer-card{
    background:#ffffff;
    border-radius:20px;
    box-shadow:0 8px 22px rgba(0,0,0,.08);
    overflow:hidden;
    border:1px solid #e4f3ea;
}

/* ================= HEADER ================= */
.offer-header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:14px 18px;
    border-bottom:1px solid #e4f3ea;
}

.offer-header h5{
    margin:0;
    font-size:15px;
    font-weight:700;
    color:#1fa84f; /* GREEN TEXT */
}

/* ================= STATUS ================= */
.status{
    padding:5px 16px;
    font-size:12px;
    border-radius:30px;
    font-weight:700;
    white-space:nowrap;
}

.status.progress{background:#fff3cd;color:#9a6b00;}
.status.ready{background:#e6f7ef;color:#1fa84f;}
.status.claimed{background:#eeeeee;color:#666;}
.status.expired{background:#fdecea;color:#b71c1c;}

/* ================= BODY ================= */
.offer-body{
    padding:20px;
    text-align:center;
}

.reward{
    font-size:26px;
    font-weight:800;
    color:#1fa84f; /* GREEN AMOUNT */
}

.reward-text{
    font-size:13px;
    color:#666;
    margin-top:4px;
}

/* ================= PROGRESS ================= */
.progress-box{
    margin:20px 0;
}

.progress-top{
    display:flex;
    justify-content:space-between;
    font-size:13px;
    font-weight:600;
    color:#1fa84f;
    margin-bottom:6px;
}

.progress{
    height:8px;
    background:#e9f5ef;
    border-radius:20px;
    overflow:hidden;
}

.progress-bar{
    height:100%;
    background:#1fa84f;
}

/* ================= TIMER ================= */
.timer{
    display:flex;
    gap:8px;
    margin:20px 0;
}

.timer div{
    flex:1;
    background:#f1faf5;
    border-radius:14px;
    padding:10px 0;
}

.timer h4{
    margin:0;
    font-size:18px;
    font-weight:800;
    color:#1fa84f;
}

.timer small{
    font-size:11px;
    color:#4d7c63;
}

/* ================= BUTTON ================= */
.btn{
    width:100%;
    padding:12px;
    border-radius:30px;
    border:none;
    font-size:14px;
    font-weight:700;
    cursor:pointer;
}

.btn-primary{background:#1fa84f;color:#fff;}
.btn-success{background:#138a3f;color:#fff;}
.btn-secondary{background:#bdbdbd;color:#fff;}

.btn:disabled{
    opacity:.75;
    cursor:not-allowed;
}

.note{
    font-size:12px;
    color:#666;
    margin-top:8px;
}

/* ================= FOOTER ================= */
.offer-footer{
    text-align:center;
    font-size:12px;
    font-weight:600;
    color:#1fa84f;
    padding:10px;
    border-top:1px solid #e4f3ea;
}

/* ================= MOBILE ================= */
@media(max-width:600px){
    .col{max-width:100%;}
}
</style>
</head>

<body>

<div class="container">
<div class="row">

<?php $__empty_1 = true; $__currentLoopData = $offerData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<?php $offer = $data['offer']; ?>

<div class="col">
<div class="offer-card">

<!-- HEADER -->
<div class="offer-header">
    <h5><?php echo e(__($offer->title)); ?></h5>

    <?php if($data['claimed']): ?>
        <span class="status claimed">Claimed</span>
    <?php elseif($data['can_claim']): ?>
        <span class="status ready">Ready</span>
    <?php else: ?>
        <span class="status progress">In Progress</span>
    <?php endif; ?>
</div>

<!-- BODY -->
<div class="offer-body">

    <div class="reward">
        <?php echo e(showAmount($offer->bonus_amount)); ?> <?php echo e($general->cur_text); ?>

    </div>
    <div class="reward-text">Bonus Reward</div>

    <div class="progress-box">
        <div class="progress-top">
            <span>Progress</span>
            <span><?php echo e($data['paid_invites']); ?> / <?php echo e($offer->required_invites); ?></span>
        </div>
        <div class="progress">
            <div class="progress-bar"
                 style="width:<?php echo e(min(100,($data['paid_invites']/$offer->required_invites)*100)); ?>%">
            </div>
        </div>
    </div>

    <!-- TIMER -->
    <div class="timer countdown" data-date="<?php echo e($offer->end_time); ?>">
        <div><h4 class="days">00</h4><small>Days</small></div>
        <div><h4 class="hours">00</h4><small>Hours</small></div>
        <div><h4 class="minutes">00</h4><small>Min</small></div>
        <div><h4 class="seconds">00</h4><small>Sec</small></div>
    </div>

    <!-- ACTION -->
    <?php if($data['claimed']): ?>
        <button class="btn btn-secondary" disabled>Already Claimed</button>
    <?php elseif($data['can_claim']): ?>
        <form method="POST" action="<?php echo e(route('user.time.offers.claim',$offer->id)); ?>">
            <?php echo csrf_field(); ?>
            <button class="btn btn-success">Claim Bonus</button>
        </form>
    <?php else: ?>
        <button class="btn btn-primary" disabled>Complete Tasks to Claim</button>
        <div class="note">
            You need <?php echo e($offer->required_invites - $data['paid_invites']); ?> more paid invites
        </div>
    <?php endif; ?>

</div>

<div class="offer-footer">
    Ends: <?php echo e(showDateTime($offer->end_time)); ?>

</div>

</div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<div class="col">
<div class="offer-card">
    <div class="offer-body">
        <h4>No active offers available</h4>
    </div>
</div>
</div>
<?php endif; ?>

</div>
</div>

<!-- ================= COUNTDOWN SCRIPT ================= -->
<script>
document.querySelectorAll('.countdown').forEach(function(box){

    let endTime = new Date(box.dataset.date).getTime();
    let card = box.closest('.offer-card');
    let status = card.querySelector('.status');
    let btn = card.querySelector('.btn');

    function update(){
        let now = new Date().getTime();
        let diff = endTime - now;

        if(diff <= 0){
            box.querySelectorAll('h4').forEach(el => el.innerText = '00');

            if(status){
                status.innerText = 'Expired';
                status.className = 'status expired';
            }

            if(btn){
                btn.innerText = 'Offer Expired';
                btn.disabled = true;
                btn.className = 'btn btn-secondary';
            }
            return;
        }

        let d = Math.floor(diff/(1000*60*60*24));
        let h = Math.floor((diff%(1000*60*60*24))/(1000*60*60));
        let m = Math.floor((diff%(1000*60*60))/(1000*60));
        let s = Math.floor((diff%(1000*60))/1000);

        box.querySelector('.days').innerText = String(d).padStart(2,'0');
        box.querySelector('.hours').innerText = String(h).padStart(2,'0');
        box.querySelector('.minutes').innerText = String(m).padStart(2,'0');
        box.querySelector('.seconds').innerText = String(s).padStart(2,'0');
    }

    update();
    setInterval(update,1000);
});
</script>

</body>
</html><?php /**PATH /home/atearnpr/demo1.atearnprofit.pro/core/resources/views/templates/ptc_diamond/user/time_offers/index.blade.php ENDPATH**/ ?>