
<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Title'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Bonus'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Invites Required'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Start Time'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('End Time'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e(__($offer->title)); ?></td>
                                <td class="fw-bold"><?php echo e(showAmount($offer->bonus_amount)); ?> <?php echo e($general->cur_text); ?></td>
                                <td><?php echo e($offer->required_invites); ?></td>
                                <td><?php echo e(showDateTime($offer->start_time)); ?></td>
                                <td><?php echo e(showDateTime($offer->end_time)); ?></td>
                                <td>
                                    <?php if($offer->isActive()): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Active'); ?></span>
                                    <?php elseif($offer->status && $offer->end_time < now()): ?>
                                        <span class="badge badge--danger"><?php echo app('translator')->get('Expired'); ?></span>
                                    <?php elseif($offer->status && $offer->start_time > now()): ?>
                                        <span class="badge badge--info"><?php echo app('translator')->get('Upcoming'); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge--warning"><?php echo app('translator')->get('Disabled'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.time.offers.claims', $offer->id)); ?>" class="btn btn-sm btn-outline--info">
                                        <i class="la la-list"></i> <?php echo app('translator')->get('Claims'); ?>
                                    </a>
                                    <a href="<?php echo e(route('admin.time.offers.edit', $offer->id)); ?>" class="btn btn-sm btn-outline--primary">
                                        <i class="la la-pen"></i> <?php echo app('translator')->get('Edit'); ?>
                                    </a>
                                    <button class="btn btn-sm btn-outline--<?php echo e($offer->status ? 'danger' : 'success'); ?> confirmationBtn"
                                        data-question="<?php echo app('translator')->get('Are you sure to'); ?> <?php echo e($offer->status ? 'disable' : 'enable'); ?> <?php echo app('translator')->get('this offer?'); ?>"
                                        data-action="<?php echo e(route('admin.time.offers.status', $offer->id)); ?>">
                                        <i class="la la-<?php echo e($offer->status ? 'eye-slash' : 'eye'); ?>"></i> <?php echo e($offer->status ? __('Disable') : __('Enable')); ?>

                                    </button>
                                    <button class="btn btn-sm btn-outline--danger confirmationBtn"
                                        data-question="<?php echo app('translator')->get('Are you sure to delete this offer?'); ?>"
                                        data-action="<?php echo e(route('admin.time.offers.delete', $offer->id)); ?>">
                                        <i class="la la-trash"></i> <?php echo app('translator')->get('Delete'); ?>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage ?? 'No offers found')); ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php if($offers->hasPages()): ?>
            <div class="card-footer">
                <?php echo e(paginateLinks($offers)); ?>

            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div id="confirmationModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Confirmation'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <p class="question"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                    <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Yes'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(route('admin.time.offers.create')); ?>" class="btn btn-outline--primary btn-sm"><i class="las la-plus"></i> <?php echo app('translator')->get('Create Offer'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function ($) {
        "use strict";
        $('.confirmationBtn').on('click', function () {
            var modal = $('#confirmationModal');
            modal.find('.question').text($(this).data('question'));
            modal.find('form').attr('action', $(this).data('action'));
            modal.modal('show');
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/atearnpr/demo1.atearnprofit.pro/core/resources/views/admin/time_offers/index.blade.php ENDPATH**/ ?>